/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module World
   
   Contains the code for functions and variables which describe the rendered world
   
*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "World.h"

// Constructor and destructor

cWorld::cWorld() {

	fRotateWorldXAxis = 0;
	fRotateWorldYAxis = 0;

	fVx = 0;
	fVy = 0;

	oDeck.fTransparancy = 1.0f;
	bDebug = false;
}

cWorld::~cWorld() {

	oPlayers.clear();
}

//This function adds a window structure to the oWindows vector. The function gives
//the window a unique ID and returns this ID to the calling function
long cWorld::AddWindow(sWindow &poWindow) {

	long lWindowId = 0;

	//find a unique ID for the window.
	for (long lIndex=0; lIndex<oWindows.size(); lIndex++) {

		if (lWindowId<oWindows[lIndex].lWindowId) lWindowId = oWindows[lIndex].lWindowId;	
		}

	lWindowId++;

	//set the id into the window structure
	poWindow.lWindowId = lWindowId;

	//save the structure in the vector
	oWindows.push_back(poWindow);	

	//return the ID of the window
	return lWindowId;
	}

//This function finds the index of the window in the oWindows vector
long cWorld::FindWindow(long plWindowId) {

	long lWindowIndex;

	lWindowIndex = -1;

	for (long lIndex=0; lIndex<oWindows.size(); lIndex++) {

		if (plWindowId == oWindows[lIndex].lWindowId) lWindowIndex = lIndex;
	}

	return lWindowIndex;
}

//This function removes a window from the oWindows vector. 
bool cWorld::DeleteWindow(long plWindowId) {

	bool bRemoved;
	long lIndex;

	bRemoved = false;
	lIndex = oWindows.size()-1;

	//find the ID in the vector and erase it.
	while (!bRemoved && lIndex>=0) {

		if (oWindows[lIndex].lWindowId == plWindowId) {

			oWindows.erase(oWindows.begin() + lIndex);
			bRemoved = true;
			}

		lIndex--;
		}

	return bRemoved;
	}
	
//This is a function which simplifies the addition of text fields to a window.
//It returns the index of the newly added text in the vector.
long cWorld::AddTextToWindow(sWindow &poWindow, 
							 char* pcText, float pfSize, DWORD pdStyle, 
							 int piLeft, int piTop, int piRight, int piBottom) {

	sText oText;

	//Setting the attributes
	strncpy_s(oText.cText, pcText, sizeof(oText.cText));
	oText.fSize = pfSize;
	oText.dStyle = pdStyle;
	oText.cTextRect.iLeft = piLeft;
	oText.cTextRect.iTop = piTop;
	oText.cTextRect.iRight = piRight;
	oText.cTextRect.iBottom = piBottom;
	
	//Setting other attributes to default values
	oText.vColor[0] = 0xFF;
	oText.vColor[1] = 0xFF;
	oText.vColor[2] = 0xFF;
	oText.fTransparancy = 1.0f;

	//Check if the text rectangle is within the window
	if (piLeft > poWindow.vSize[0]) oText.cTextRect.iLeft = poWindow.vSize[0];
	if (piRight > poWindow.vSize[0]) oText.cTextRect.iRight = poWindow.vSize[0];
	if (piTop > poWindow.vSize[1]) oText.cTextRect.iTop = poWindow.vSize[1];
	if (piBottom > poWindow.vSize[1]) oText.cTextRect.iBottom = poWindow.vSize[1];

	oText.iX = oText.cTextRect.iLeft;
	oText.iY = oText.cTextRect.iTop;

	//Adding the text to the window
	poWindow.oTexts.push_back(oText);

	return poWindow.oTexts.size() - 1;
	}	

//This is a function which simplifies the addition of buttons to a window.
//It returns the index of the newly added button in the vector.
long cWorld::AddButtonToWindow(sWindow &poWindow, long lButtonId, char* pcCaption, 
					   int piLeft, int piTop, int piRight, int piBottom) {

	
	sButton oButton;

	//Setting the attributes
	oButton.lId = lButtonId;
	strncpy_s(oButton.cCaption, pcCaption, sizeof(oButton.cCaption));
	oButton.cButtonRect.iLeft = piLeft;
	oButton.cButtonRect.iTop = piTop;
	oButton.cButtonRect.iRight = piRight;
	oButton.cButtonRect.iBottom = piBottom;

	//Setting default values to other attributes
	oButton.fTransparancy = 1.0f;
	oButton.vBackgroundColor[0]=0.2f;
	oButton.vBackgroundColor[1]=0.2f;
	oButton.vBackgroundColor[2]=0.2f;
	oButton.vCaptionColor[0]=1.0f;
	oButton.vCaptionColor[1]=1.0f;
	oButton.vCaptionColor[2]=1.0f;

	//Check if the text rectangle is within the window
	if (piLeft > poWindow.vSize[0]) oButton.cButtonRect.iLeft = poWindow.vSize[0];
	if (piRight > poWindow.vSize[0]) oButton.cButtonRect.iRight = poWindow.vSize[0];
	if (piTop > poWindow.vSize[1]) oButton.cButtonRect.iTop = poWindow.vSize[1];
	if (piBottom > poWindow.vSize[1]) oButton.cButtonRect.iBottom = poWindow.vSize[1];

	//Adding the text to the window
	poWindow.oButtons.push_back(oButton);

	return poWindow.oButtons.size() - 1;
	}
		
//This function returns the number of selected cards in the hand of the player
long cWorld::GetNumberCardSelected(long plPlayer) {

	long lCount;
	
	lCount = 0;

	for (long lIndex = oPlayers[plPlayer].oCards.size()-1; lIndex>=0; lIndex--) {

		if (oPlayers[plPlayer].oCards[lIndex]->bSelected) lCount++;
		}	
	return lCount;
	}

//This function returns the id of the card of a selected card. It returns
//-1 if no selected card is found
sCard* cWorld::GetSelectedCard(long plPlayer, long plNumber) {

	long lCount;
	sCard* oCard;

	oCard = NULL;
	lCount = 0;

	for (long lIndex = oPlayers[plPlayer].oCards.size()-1; (lIndex>=0 && oCard==NULL); lIndex--) {

		if (oPlayers[plPlayer].oCards[lIndex]->bSelected) lCount++;
		if (lCount==plNumber) {

			oCard = oPlayers[plPlayer].oCards[lIndex];
			}
		}	
	
	return oCard;
	}

//Some function to position stuff in the world

void cWorld::w_PositionPlayers() {
     
    vec_f vNormalVector;
    vec_f vCrossProductVector;
    vec_f vHelperVector;
    float fAngle;
	long lNumberPlayers;

	lNumberPlayers = oPlayers.size();
	
	//calculate the rotation for the player
	
	for (long lIndex=0; lIndex<lNumberPlayers; lIndex++) {
    
		oPlayers[lIndex].fRotationPosition = fmod(pi2 - (pi2 / lNumberPlayers) * lIndex, pi2);

		oPlayers[lIndex].vPosition[0] = 5.8f * cos(oPlayers[lIndex].fRotationPosition);
		oPlayers[lIndex].vPosition[1] = -0.5f;
		oPlayers[lIndex].vPosition[2] = 5.8f * sin(oPlayers[lIndex].fRotationPosition);
		
		//calculate the normal vector. Along this vector all cards will be positioned
		vHelperVector[0]=0;
		vHelperVector[1]=oPlayers[lIndex].vPosition[1] + 1;
		vHelperVector[2]=0;
    
		CrossProduct(oPlayers[lIndex].vPosition, vHelperVector, vCrossProductVector);
		NormalizeVector(vCrossProductVector, vNormalVector);

		fAngle = (float)asin(vNormalVector[2]);
    
		//do some conversion on the angle. The normal vector is always positive it seems 
		if (oPlayers[lIndex].vPosition[2]<0) {
			fAngle += pi;
			}
		else {
			fAngle = -fAngle;
			}
	
		oPlayers[lIndex].fRotationCard = -fAngle;
	}
}

void cWorld::CrossProduct(vec_f pV1, vec_f pV2, vec_f pVcross) {
	pVcross[0] = pV1[1]*pV2[2] - pV1[2]*pV2[1];
	pVcross[1] = pV1[2]*pV2[0] - pV1[0]*pV2[2];
	pVcross[2] = pV1[0]*pV2[1] - pV1[1]*pV2[0];
}

void cWorld::NormalizeVector(vec_f pVin, vec_f pVnormal) {
	
	float length;

	length = sqrt (pVin[0]*pVin[0] + pVin[1]*pVin[1] + pVin[2]*pVin[2]);
	if (length == 0)
	{
       length = 1;
	}

	pVnormal[0] = pVin[0]/length;
	pVnormal[1] = pVin[1]/length;
	pVnormal[2] = pVin[2]/length;
}
