/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module WindowTask
   
   Contains the code code of the TaskBar window   
   
*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Renderer.h"
#include "Animator.h"
#include "CardGameEngine.h"
#include "CardGame.h"
#include "WindowTask.h"

//Constructor and destructor

cWindowTask::cWindowTask(cSystem* poSystem) {

	oSystem = poSystem;
	}

cWindowTask::~cWindowTask() {

	DestroyWindow( oSystem->hWndTaskBar);
}

bool cWindowTask::CreateTaskWindow(HINSTANCE hInstance, WNDPROC WndProc) {

	WNDCLASS wc;
	DWORD dWindowStyle;
    
    // register window class
    wc.style = CS_OWNDC | CS_DBLCLKS;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)GetStockObject( NULL_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "MeusesoftCardGame_Taskbar";
    RegisterClass( &wc );

    // create taskbar window
    dWindowStyle = WS_CHILD | WS_VISIBLE;

	oSystem->hWndTaskBar = CreateWindow( 
          "MeusesoftCardGame_Taskbar", "CardGame_Task", 
            dWindowStyle,
          oSystem->iGameWindowWidth, 0, 
		  oSystem->iTaskWindowWidth, oSystem->iTaskWindowHeight,
          oSystem->hWndMainWindow, NULL, hInstance, NULL);

	return (oSystem->hWndTaskBar!=NULL);
}


LRESULT cWindowTask::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  //return DefWindowProc(hWnd, message, wParam, lParam);
  

  switch (message) 
  {
      case WM_CREATE:
           return 0;

      case WM_DESTROY:
           return 0;

	  case WM_ERASEBKGND:
	  case WM_PAINT:

			HDC hDC;
			RECT hRect;
			HBRUSH hBrush;

			hDC = GetDC(oSystem->hWndTaskBar);
			GetClientRect(oSystem->hWndTaskBar, &hRect);
			hBrush = CreateSolidBrush(RGB(255, 0, 0));

			FillRect(hDC, &hRect, hBrush);

			ReleaseDC(oSystem->hWndTaskBar, hDC);
			DeleteObject(hBrush);

			//return 0;
        
      default:
           return DefWindowProc(hWnd, message, wParam, lParam);
           }
}

