/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module WindowMain
   
   Contains the code code the main window   
   
*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Renderer.h"
#include "Animator.h"
#include "CardGameEngine.h"
#include "CardGame.h"
#include "WindowGame.h"
#include "WindowTask.h"
#include "WindowMain.h"

//Constructor and destructor

cWindowMain::cWindowMain(cSystem* poSystem) {

	oSystem = poSystem;

	oTaskWindow = NULL;
	oGameWindow = NULL;
	}

cWindowMain::~cWindowMain() {

	GetWindowPlacement(oSystem->hWndMainWindow, &oSystem->oWindowPlacement);

	if (oTaskWindow) delete oTaskWindow;
	if (oGameWindow) delete oGameWindow;

	DestroyWindow(oSystem->hWndMainWindow);
	}

//Window creation

bool cWindowMain::CreateMainWindow(HINSTANCE hInstance, WNDPROC WndProc) {

	WNDCLASS wc;
	DWORD dWindowStyle;
	bool bReturn;
    
	// register window class
    wc.style = CS_OWNDC | CS_DBLCLKS;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName = MAKEINTRESOURCE(IDR_MAINMENU);
    wc.lpszClassName = "MeusesoftCardGame_Main";
    RegisterClass( &wc );
    
    // load settings from registry or ini file
	oSystem->LoadSettings();
    
	//set the window style
    dWindowStyle = WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX |  WS_MAXIMIZEBOX;

	switch (oSystem->iWindowState) {

		case 1:
			dWindowStyle |= WS_MAXIMIZE;
			break;

		case 2:
			dWindowStyle = 0;//WS_VISIBLE;
			break;
		}

	//create the main window
	oSystem->hWndMainWindow = CreateWindow( 
          "MeusesoftCardGame_Main", "CardGame", 
          dWindowStyle,
		  oSystem->iWindowState<2 ? oSystem->iWindowPositionX : 0, 
		  oSystem->iWindowState<2 ? oSystem->iWindowPositionY : 0, 
		  oSystem->iWindowState<2 ? oSystem->iWindowWidth : GetSystemMetrics(SM_CXSCREEN), 
		  oSystem->iWindowState<2 ? oSystem->iWindowHeight : GetSystemMetrics(SM_CYSCREEN), 
		  NULL, NULL, hInstance, NULL);

	if (oSystem->hWndMainWindow != NULL) {

		//position child windows inside main window
		PositionChildWindows();

		//create objects for child windows
		oGameWindow = new cWindowGame(oSystem);
		oTaskWindow = new cWindowTask(oSystem);

		//create child windows
		bReturn = oGameWindow->CreateGameWindow(hInstance, WndProc);
		//bReturn = bReturn && oTaskWindow->CreateTaskWindow(hInstance, WndProc);

		//Show the window (and tell it is maximized if that was the last known state)
		ShowWindow(oSystem->hWndMainWindow, oSystem->iWindowState != 1 ? SW_NORMAL : SW_MAXIMIZE);

		//If the window is full screen then change it style
		if (oSystem->iWindowState == 2) {

			long lValue = GetWindowLong(oSystem->hWndMainWindow, GWL_STYLE);
			lValue &= ~(WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX |  WS_MAXIMIZEBOX);
			SetWindowLong(oSystem->hWndMainWindow, GWL_STYLE, lValue);
			}

		//Load accelerators
		oSystem->hAcceleratorMain = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATORMAIN));
	}

	return (bReturn && (oSystem->hWndMainWindow!=NULL));
}

//This routing handles the events/messages generated by Windows.

LRESULT cWindowMain::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
 
	if (hWnd==oSystem->hWndGameWindow) return oGameWindow->WndProc(hWnd, message, wParam, lParam);
	if (hWnd==oSystem->hWndTaskBar) return oTaskWindow->WndProc(hWnd, message, wParam, lParam);

	switch (message) 
		{
		case WM_CREATE:
			return 0;

		case WM_MOUSEWHEEL:

			oGameWindow->WndProc(hWnd, message, wParam, lParam);
			return 0;
		
		case WM_CLOSE:
           PostQuitMessage( 0 );
           return 0;

      case WM_DESTROY:
           return 0;
        
	  case WM_MOVE:

		if (hWnd == oSystem->hWndMainWindow && oSystem->iWindowState == 0) {

			long lValue = GetWindowLong(oSystem->hWndMainWindow, GWL_STYLE);

			if ((lValue & WS_MAXIMIZE)==0) {

				RECT cWindowRect;

				//we use getwindowrect to determine the size of the window because 
				//wm_move returns client coordinates and not window coordinates
				GetWindowRect(oSystem->hWndMainWindow, &cWindowRect);
				
				oSystem->iWindowPositionX = cWindowRect.left;
				oSystem->iWindowPositionY = cWindowRect.top;
				oSystem->iWindowWidth = cWindowRect.right - cWindowRect.left;
				oSystem->iWindowHeight = cWindowRect.bottom - cWindowRect.top;
				}
			}

		  return 0;
	  
		case WM_SIZE:
						
			if (hWnd == oSystem->hWndMainWindow) {
				
				if (oSystem->iWindowState != 2) {

					//determine if the window is maximized/restored.
					switch (wParam){

						case SIZE_MAXIMIZED:

							oSystem->iWindowState = 1; //maximized
							break;

						case SIZE_RESTORED:

							oSystem->iWindowState = 0; //normal
							break;
						}
					}
				
				PositionChildWindows();

				::MoveWindow(oSystem->hWndGameWindow, 0, 0, oSystem->iGameWindowWidth, oSystem->iGameWindowHeight, false);
				::MoveWindow(oSystem->hWndTaskBar, oSystem->iGameWindowWidth, 0, oSystem->iTaskWindowWidth, oSystem->iTaskWindowHeight, true);
				if (oGameWindow) oGameWindow->onSize();
				}
			
			return 0;
      
      case WM_KEYDOWN:
           switch (wParam) 
           {
               case VK_ESCAPE:
                    PostQuitMessage( 0 );
                    return 0;
            
               case VK_F1:
                    if (oGameWindow) oGameWindow->onKey(1);
                    return 0;

               case VK_F2:
                    if (oGameWindow) oGameWindow->onKey(2);
                    return 0;

               case VK_F3:
                    if (oGameWindow) oGameWindow->onKey(3);
                    return 0;

               case VK_F4:
                    if (oGameWindow) oGameWindow->onKey(4);
                    return 0;

               case VK_F5:
                    if (oGameWindow) oGameWindow->onKey(5);
                    return 0;
               
				case VK_F6:
                    if (oGameWindow) oGameWindow->onKey(6);
                    return 0;

		   }

		case WM_CHAR: {

			if (wParam>=0x60 && wParam<0x80 && (lParam & 0x0f)==1) {
				sLineInput += (char)wParam;
				}
			
			if (wParam==0x0D) {

				oGameWindow->onLineInput(sLineInput);
				sLineInput = "";
				}
			}
	  
	  case WM_COMMAND: {
			
		  if (onCommand(wParam, lParam)) return 0;
		  }

      default:
           return DefWindowProc(hWnd, message, wParam, lParam);
           }
}

void cWindowMain::onRender() {

	oGameWindow->onRender();
}

//this function processes the WM_COMMAND message. Returns true if it is processed
bool cWindowMain::onCommand(WPARAM wParam, LPARAM lParam) {

	bool bReturn;

	bReturn = false;
	
	switch(LOWORD(wParam)) {

		case ID_FULLSCREEN: {

			DoToggleFullScreen();
			bReturn = true;
			break;
			}

		default: {

				bReturn = oGameWindow->onCommand(wParam, lParam);
				//if (!bResult) bResult = oTaskWindow->onCommand(wParam, lParam);
				}
	}
	
	return bReturn;
}


void cWindowMain::DoToggleFullScreen() {

	long lValue;
	RECT cWindowRect;
	
	if (oSystem->iWindowState!=2) {
		
		//save the window state and set the window state to full screen
		if (oSystem->iWindowState==0) {
			GetWindowRect(oSystem->hWndMainWindow, &cWindowRect);
			oSystem->iWindowPositionX = cWindowRect.left;
			oSystem->iWindowPositionY = cWindowRect.top;
			oSystem->iWindowWidth = cWindowRect.right - cWindowRect.left;
			oSystem->iWindowHeight = cWindowRect.bottom - cWindowRect.top;
			}

		oSystem->oWindowPlacement.length = sizeof(oSystem->oWindowPlacement);
		GetWindowPlacement(oSystem->hWndMainWindow, &oSystem->oWindowPlacement);

		oSystem->iOldWindowState = oSystem->iWindowState;
		oSystem->iWindowState=2;
		
		//change the appearance of the window
		lValue = GetWindowLong(oSystem->hWndMainWindow, GWL_STYLE);
		lValue &= ~(WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX |  WS_MAXIMIZEBOX);
		SetWindowLong(oSystem->hWndMainWindow, GWL_STYLE, lValue);

		//maximize it
		SetWindowPos(oSystem->hWndMainWindow,HWND_TOPMOST,
			0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),
			SWP_SHOWWINDOW);
		}
	else {

		//change the appearance of the window
		lValue = GetWindowLong(oSystem->hWndMainWindow, GWL_STYLE);
		lValue |= WS_CAPTION  | WS_SYSMENU | WS_MINIMIZEBOX |  WS_MAXIMIZEBOX | WS_THICKFRAME | WS_VISIBLE;
		SetWindowLong(oSystem->hWndMainWindow, GWL_STYLE, lValue);

		//no longer on top
		SetWindowPos(oSystem->hWndMainWindow, HWND_NOTOPMOST,
			0, 0, 0, 0, 				
			SWP_SHOWWINDOW | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED);
		
		//change the state to its former value
		oSystem->iWindowState = oSystem->iOldWindowState;

		//restore the placement
		SetWindowPlacement(oSystem->hWndMainWindow, &oSystem->oWindowPlacement);
	}

	//reset the viewport of the game window
	PositionChildWindows();
	oGameWindow->onSize();
}

void cWindowMain::PositionChildWindows() {

	RECT cClientRect;

	::GetClientRect(oSystem->hWndMainWindow, &cClientRect);

	oSystem->iGameWindowHeight = cClientRect.bottom - cClientRect.top;
	oSystem->iGameWindowWidth = cClientRect.right - cClientRect.left;

	return;
	
	oSystem->iGameWindowWidth = (oSystem->iGameWindowWidth >= 800 ? oSystem->iGameWindowWidth * 0.75 : oSystem->iGameWindowWidth - 200);
	
	oSystem->iTaskWindowWidth = cClientRect.right - cClientRect.left - oSystem->iGameWindowWidth;
	oSystem->iTaskWindowHeight = oSystem->iGameWindowHeight;
	}
