/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module System
   
   Contains the code for functions and variables which depend on or reflect state
   of the Operation System. This module contains code which is specific for an
   Operation System   
   
*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "System.h"

//Constructor and destructor
cSystem::cSystem() {
                   
    hDC = NULL;
    hWndGameWindow = NULL;
    hWndTaskBar = NULL;
    hWndMainWindow = NULL;
    hRC = NULL;
    
    iPixelFormatMultiSample = 0;
}

cSystem::~cSystem() {
                   
	SaveSettings();
}

//Functions specific for the operation system
DWORD cSystem::GetTickCount() {
 
    return ::GetTickCount();     
}

	
//Handler of system messages. Returns true if a QUIT message is processed

bool cSystem::PumpWaitingMessage() {

    MSG msg;
	bool bResult;

	bResult = false;

	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {

		wParam = msg.wParam;
		lParam = msg.lParam;
		
		if (hAcceleratorMain!=NULL) {
				
			//Search through the accelerator tabel and checks if a key pressed matches
			//a predefined accelerator
			TranslateAccelerator(hWndMainWindow,
								 hAcceleratorMain,
								 &msg);
			}
			
		if (msg.message == WM_QUIT) {

			bResult = true;
			} 
		else 
			{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			}
		}

	return bResult;
	}

//Function to save settings to register or other something else
bool cSystem::SaveSettings() {

	WriteInteger("Window", "Bottom", oWindowPlacement.rcNormalPosition.bottom);
	WriteInteger("Window", "Right", oWindowPlacement.rcNormalPosition.right);
	WriteInteger("Window", "Left", oWindowPlacement.rcNormalPosition.left);
	WriteInteger("Window", "Top", oWindowPlacement.rcNormalPosition.top);
	WriteInteger("Window", "MaximizeX", oWindowPlacement.ptMaxPosition.x);
	WriteInteger("Window", "MaximizeY", oWindowPlacement.ptMaxPosition.y);
	WriteInteger("Window", "State", iWindowState);
	WriteInteger("Window", "OldState", iOldWindowState);

	return true;
}

//Function to load settings from register or whatever
bool cSystem::LoadSettings() {

	//Fill Windowplacement structure
	oWindowPlacement.rcNormalPosition.bottom = ReadInteger("Window", "Bottom", 600);
	oWindowPlacement.rcNormalPosition.right = ReadInteger("Window", "Right", 800);
	oWindowPlacement.rcNormalPosition.left = ReadInteger("Window", "Left", 0);
	oWindowPlacement.rcNormalPosition.top = ReadInteger("Window", "Top", 0);
	oWindowPlacement.ptMaxPosition.x = ReadInteger("Window", "MaximizeX", -1);
	oWindowPlacement.ptMaxPosition.y = ReadInteger("Window", "MaximizeY", -1);
	oWindowPlacement.ptMinPosition.x = ReadInteger("Window", "MaximizeX", -1);
	oWindowPlacement.ptMinPosition.y = ReadInteger("Window", "MaximizeY", -1);
	
	iWindowState = ReadInteger("Window", "State", 0);
	iOldWindowState = ReadInteger("Window", "OldState", iWindowState);

	oWindowPlacement.length = sizeof(oWindowPlacement);
	oWindowPlacement.flags = iOldWindowState==1 ? WPF_RESTORETOMAXIMIZED : 0;
	oWindowPlacement.showCmd = iOldWindowState==1 ? SW_SHOWMAXIMIZED : SW_SHOWNORMAL;

	//Fill window variables
	iWindowHeight = oWindowPlacement.rcNormalPosition.bottom - oWindowPlacement.rcNormalPosition.top;
	iWindowWidth = oWindowPlacement.rcNormalPosition.right - oWindowPlacement.rcNormalPosition.left;
	iWindowPositionX = oWindowPlacement.rcNormalPosition.left;
	iWindowPositionY = oWindowPlacement.rcNormalPosition.top;

	return true;
}


//---------------------------------------------------------------------------------

int cSystem::ReadInteger(std::string pKey, std::string pEntry, int piDefaultValue) {

	//read an integer from the registry. If the entry doesn't exist use the
	//value in piDefaultValue
	long lResult;
	int  iReturn;
	DWORD dValue;
	DWORD dValueSize;
	HKEY hHandle;
	std::string sKey;

	sKey = RegistryBase;
	sKey += pKey;	
	
	iReturn = piDefaultValue;

	lResult = ::RegOpenKeyEx(HKEY_CURRENT_USER, sKey.c_str(), 0, KEY_READ, &hHandle);
	
	if (lResult==ERROR_SUCCESS) {
		dValueSize = sizeof(DWORD);
		
		lResult = ::RegQueryValueEx(hHandle, pEntry.c_str(), NULL, NULL, (LPBYTE)&dValue, &dValueSize);

		if (lResult==ERROR_SUCCESS) {

			iReturn = dValue;
		}

		::RegCloseKey(hHandle);
	}

	return iReturn;
}

//---------------------------------------------------------------------------------

void cSystem::WriteInteger(std::string pKey, std::string pEntry, int piValue) {

	//write an integer to the registry. If the entry doesn't exist, create it
	long lResult;
	DWORD dValue;
	HKEY hHandle;
	std::string sKey;

	sKey = RegistryBase;
	sKey += pKey;	
	
	lResult = ::RegCreateKeyEx(HKEY_CURRENT_USER, sKey.c_str(), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hHandle, NULL);
	
	if (lResult==ERROR_SUCCESS) {

		dValue = piValue;
		
		::RegSetValueEx(hHandle, pEntry.c_str(), NULL, REG_DWORD, (LPBYTE)&dValue, sizeof(DWORD));
		
		if (lResult!=ERROR_SUCCESS) {

			//TRACE0("Failed to write registry (integer)\n");
		}

		::RegCloseKey(hHandle);
	}
	else {

		//TRACE0("Failed to open registry key (write integer)\n");
	}
}
	
//---------------------------------------------------------------------------------

void cSystem::WriteString(std::string pKey, std::string pEntry, std::string psValue) {

	//write an integer to the registry. If the entry doesn't exist, create it
	long lResult;
	std::string sKey;
	std::string sReturn;
	HKEY hHandle;

	sKey = RegistryBase;
	sKey += pKey;	
	
	lResult = ::RegCreateKeyEx(HKEY_CURRENT_USER, sKey.c_str(), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hHandle, NULL);
	
	if (lResult==ERROR_SUCCESS) {

		::RegSetValueEx(hHandle, pEntry.c_str(), NULL, REG_SZ, (LPBYTE)psValue.c_str(), (DWORD)psValue.size() + 1);

		if (lResult!=ERROR_SUCCESS) {

			//TRACE0("Failed to write registry (string)\n");
		}

		::RegCloseKey(hHandle);
	}
	else {

		//TRACE0("Failed to open registry key (write string)\n");
	}
}

//---------------------------------------------------------------------------------

void cSystem::ReadString(std::string pKey, std::string pEntry, std::string psDefaultValue, std::string &psValue) {

	//read an integer from the registry. If the entry doesn't exist use the
	//value in piDefaultValue
	long lResult;
	std::string sKey;
	char sValue[MAX_PATH];
	HKEY hHandle;
	DWORD dType, dCount;

	sKey = RegistryBase;
	sKey += pKey;	
	
	psValue = psDefaultValue;

	lResult = ::RegOpenKeyEx(HKEY_CURRENT_USER, sKey.c_str(), 0, KEY_READ, &hHandle);
	if (lResult==ERROR_SUCCESS) {

		lResult = RegQueryValueEx(hHandle, pEntry.c_str(), NULL, &dType, NULL, &dCount);
		
		if (lResult == ERROR_SUCCESS && dType == REG_SZ) {
			
			RegQueryValueEx(hHandle, pEntry.c_str(), NULL, &dType, (LPBYTE)&sValue, &dCount);

			if (lResult == ERROR_SUCCESS) {

				psValue = sValue;
			}
		}

	::RegCloseKey(hHandle);
	}
}


