#include "TWinSock.h"
#pragma hdrstop

//-----------------------------------------------------------------------------

TWinSockets::TWinSockets() {

   WORD wVersionRequested;
   WSADATA wsaData;
   int err;

   wVersionRequested = MAKEWORD( 2, 2 );

   err = WSAStartup( wVersionRequested, &wsaData );
   if ( err != 0 ) {
       /* Tell the user that we couldn't find a useable */
       /* WinSock DLL.                                  */
       return;
   	}

   /* Confirm that the WinSock DLL supports 2.2.*/
   /* Note that if the DLL supports versions greater    */
   /* than 2.2 in addition to 2.2, it will still return */
   /* 2.2 in wVersion since that is the version we      */
   /* requested.                                        */

   if ( LOBYTE( wsaData.wVersion ) != 2 ||
            HIBYTE( wsaData.wVersion ) != 2 ) {
       /* Tell the user that we couldn't find a useable */
       /* WinSock DLL.                                  */
       WSACleanup( );
       return;
   	}

   /* The WinSock DLL is acceptable.  Proceed.  */
	bInitialised = true;
    bDebugMode = false;
	}

TWinSockets::~TWinSockets() {

	//close all open sockets immediately


    //cleanup winsocket DLL
    if (bInitialised) {
    	WSACleanup( );
      }
	}

//Create a new socket and return a pointer to it if successful.
TWinSocket* TWinSockets::NewConnection(const char* pcHost, u_short nPort) {

    TWinSocket* oSocket = NULL;

    if (bInitialised) {
      oSocket = new TWinSocket();
      if (!oSocket->OpenConnection(pcHost, nPort)) {
      	delete oSocket;
         oSocket=NULL;
      	}
      }

	 if (oSocket!=NULL) {
    	oSocket->bDebugMode = bDebugMode;
      }
    return oSocket;
    }

//Create a new socket and return a pointer to it if successful.
TWinSocket* TWinSockets::NewListener(const char* pcAddress, u_short nPort, HWND hWindow) {

   TWinSocket* oSocket = NULL;

   if (bInitialised) {

      oSocket = new TWinSocket();
      oSocket->bDebugMode = bDebugMode;

      char nummer[10];

      if (!oSocket->SetupListener(pcAddress, nPort)) {
        delete oSocket;
        oSocket=NULL;
      	}
      else {
        //als hWindow niet null is dan kunnen we de messages initialiseren
        if (hWindow!=NULL) {

            if (WSAAsyncSelect(oSocket->hConnection, hWindow, WM_USER, FD_ACCEPT)==SOCKET_ERROR)  {
                //message niet geregistreerd, socket afsluiten en fout
                //teruggeven

                //itoa(WSAGetLastError(), nummer, 10);
                //::MessageBox(NULL, nummer ,"test", MB_OK);
                delete oSocket;
                oSocket=NULL;
                }
            }
        }
      }

   return oSocket;
   }

//-----------------------------------------------------------------------------

bool TWinSocket::SetReadEvent(HWND hWindow, int iDelta) {

    bool bRetval = false;

    LogFunction("SetReadEvent");

    if (WSAAsyncSelect(hConnection, hWindow, WM_USER+iDelta, FD_READ)==0)  {
        //message geregistreerd
        bRetval = true;
        }
    else {
        LogError();
        }

    return bRetval;
    }

//-----------------------------------------------------------------------------

TWinSocket::TWinSocket() {

	hConnection = INVALID_SOCKET;
    iMaxMessageSize = 0;

	}

TWinSocket::~TWinSocket() {

    int iBytesReceived = -1;
    char cBuffer[1024];

    LogFunction("~TWinSocket");

	if (hConnection!=INVALID_SOCKET) {
        shutdown(hConnection, SD_BOTH);

        while (iBytesReceived!=SOCKET_ERROR && iBytesReceived!=0) {

            iBytesReceived = recv(hConnection, cBuffer, sizeof(cBuffer), 0);
            }

        closesocket(hConnection);
        hConnection = INVALID_SOCKET;
   	    }
	}

//// LookupAddress /////////////////////////////////////////////////////
// Given an address string, determine if it's a dotted-quad IP address
// or a domain address.  If the latter, ask DNS to resolve it.  In
// either case, return resolved IP address.  If we fail, we return
// INADDR_NONE.

u_long TWinSocket::LookupAddress(const char* pcHost)
{
    LogFunction("LookupAddress");

    u_long nRemoteAddr = inet_addr(pcHost);
    if (nRemoteAddr == INADDR_NONE) {
        // pcHost isn't a dotted IP, so resolve it through DNS
        hostent* pHE = gethostbyname(pcHost);
        if (pHE == 0) {
            return INADDR_NONE;
        }
        nRemoteAddr = *((u_long*)pHE->h_addr_list[0]);
    }

    return nRemoteAddr;
}


//// EstablishConnection ///////////////////////////////////////////////
// Connects to a given address, on a given port, both of which must be
// in network byte order.  Returns newly-connected socket if we succeed,
// or INVALID_SOCKET if we fail.

bool TWinSocket::OpenConnection(const char* pcHost, u_short nPort)
{
    bool bResult = false;

    LogFunction("OpenConnection");

    u_long nRemoteAddr = LookupAddress(pcHost);

    if (nRemoteAddr!=INADDR_NONE) {

       // Create a stream socket
       hConnection = socket(AF_INET, SOCK_STREAM, 0);
       if (hConnection != INVALID_SOCKET) {
           sockaddr_in sinRemote;
           sinRemote.sin_family = AF_INET;
           sinRemote.sin_addr.s_addr = nRemoteAddr;
           sinRemote.sin_port = nPort;
           if (connect(hConnection, (sockaddr*)&sinRemote, sizeof(sockaddr_in)) ==
                   SOCKET_ERROR) {

               LogError();
               hConnection = INVALID_SOCKET;
           		}
           else {
               bResult = true;
           		}
       	    }
    	}

    return bResult;
}

bool TWinSocket::SetupListener(const char* pcAddress, u_short nPort)
{
    bool bRetval = false;

    LogFunction("SetupListener");

    u_long nInterfaceAddr = inet_addr(pcAddress);
    if (nInterfaceAddr != INADDR_NONE) {
        hConnection = socket(AF_INET, SOCK_STREAM, 0);
        if (hConnection != INVALID_SOCKET) {
            sockaddr_in sinInterface;
            sinInterface.sin_family = AF_INET;
            sinInterface.sin_addr.s_addr = nInterfaceAddr;
            sinInterface.sin_port = nPort;
            if (bind(hConnection, (sockaddr*)&sinInterface,
                    sizeof(sockaddr_in)) != SOCKET_ERROR) {
                listen(hConnection, 1);
                bRetval = true;
                }
            else {
                LogError();
                }
        }
    }

    return bRetval;
}

TWinSocket* TWinSocket::AcceptConnection() {

   LogFunction("AcceptConnection");

   TWinSocket* oAcceptedConnection;
	sockaddr_in sinRemote;

   oAcceptedConnection = new TWinSocket();
   int nAddrSize = sizeof(sinRemote);
   oAcceptedConnection->hConnection = accept(hConnection, (sockaddr*)&sinRemote, &nAddrSize);

   if (oAcceptedConnection->hConnection != INVALID_SOCKET) {
        LogError();
   	}
   	else {
        //gelukt, connection teruggeven
        delete oAcceptedConnection;
        oAcceptedConnection = NULL;
        }

   return oAcceptedConnection;
}

bool TWinSocket::ReadMessage(char* cMessage, int iMaxMessageSize) {

	LogFunction("ReadMessage");

   bool bRetValue = false;

	if (recv(hConnection, cMessage, iMaxMessageSize, 0)!=SOCKET_ERROR) {
      bRetValue = true;
   	}
   else {
      LogError();
   	}

   return bRetValue;
   }


bool TWinSocket::SendMessage(char* cMessage, int iMessageSize) {

    LogFunction("SendMessage");

    char cOptionSize[128];
    int  iOptionSize;

    bool bRetValue = false;

    if (iMaxMessageSize==0) {
        //bepaal de max omvang van een bericht

        if (getsockopt(hConnection, SOL_SOCKET, SO_MAX_MSG_SIZE, cOptionSize, &iOptionSize)==0) {
            //als -1 dan is het blijkbaar een socketstream: geen max grootte
            //van berichten.

            iMaxMessageSize = (long)*cOptionSize;
            }
        }

    if (iMessageSize<=iMaxMessageSize || iMaxMessageSize==-1) {
        //verstuur bericht
        if (send(hConnection, cMessage, iMessageSize, 0)!=SOCKET_ERROR) {
            //er is geen fout opgetreden
            bRetValue = true;
            }
        else {
            LogError();
            }
        }

    return bRetValue;
    
    }


int TWinSocket::GetLastWinsockError() {

    return WSAGetLastError();
    }

bool TWinSocket::FormatError(int iLastError, char* cMessage, int iMessageSize) {

    bool bRetValue = true;

    switch (iLastError) {

        case WSAEACCES: {
            strncpy(cMessage, "Permission denied", iMessageSize);
            break;
            }

        case WSAEADDRINUSE: {
            strncpy(cMessage, "Address already in use", iMessageSize);
            break;
            }

        case WSAEADDRNOTAVAIL: {
            strncpy(cMessage, "Cannot assign requested address", iMessageSize);
            break;
            }

        case WSAEAFNOSUPPORT: {
            strncpy(cMessage, "Address family not supported by protocol family", iMessageSize);
            break;
            }

        case WSAEALREADY: {
            strncpy(cMessage, "Operation already in progress", iMessageSize);
            break;
            }

        case WSAECONNABORTED: {
            strncpy(cMessage, "Software caused connection abort", iMessageSize);
            break;
            }

        case WSAECONNREFUSED: {
            strncpy(cMessage, "Connection refused", iMessageSize);
            break;
            }

        case WSAECONNRESET: {
            strncpy(cMessage, "Connection reset by peer", iMessageSize);
            break;
            }

        case WSAEDESTADDRREQ: {
            strncpy(cMessage, "Destination address required", iMessageSize);
            break;
            }

        case WSAEFAULT: {
            strncpy(cMessage, "Bad address", iMessageSize);
            break;
            }

        case WSAEHOSTDOWN: {
            strncpy(cMessage, "Host is down", iMessageSize);
            break;
            }

        case WSAEHOSTUNREACH: {
            strncpy(cMessage, "No route to host", iMessageSize);
            break;
            }

        case WSAEINPROGRESS: {
            strncpy(cMessage, "Operation now in progress", iMessageSize);
            break;
            }

        case WSAEINTR: {
            strncpy(cMessage, "Interrupted function call", iMessageSize);
            break;
            }

        case WSAEINVAL: {
            strncpy(cMessage, "Invalid argument", iMessageSize);
            break;
            }

        case WSAEISCONN: {
            strncpy(cMessage, "Socket is already connected", iMessageSize);
            break;
            }

        case WSAEMFILE: {
            strncpy(cMessage, "Too many open files", iMessageSize);
            break;
            }

        case WSAEMSGSIZE: {
            strncpy(cMessage, "Message too long", iMessageSize);
            break;
            }

        case WSAENETDOWN: {
            strncpy(cMessage, "Network is down", iMessageSize);
            break;
            }

        case WSAENETRESET: {
            strncpy(cMessage, "Network dropped connection on reset", iMessageSize);
            break;
            }

        case WSAENETUNREACH: {
            strncpy(cMessage, "Network is unreachable", iMessageSize);
            break;
            }

        case WSAENOBUFS: {
            strncpy(cMessage, "No buffer space available", iMessageSize);
            break;
            }

        case WSAENOPROTOOPT: {
            strncpy(cMessage, "Bad protocol option", iMessageSize);
            break;
            }

        case WSAENOTCONN: {
            strncpy(cMessage, "Socket is not connected", iMessageSize);
            break;
            }

        case WSAENOTSOCK: {
            strncpy(cMessage, "Socket operation on non-socket", iMessageSize);
            break;
            }

        case WSAEOPNOTSUPP: {
            strncpy(cMessage, "Operation not supported", iMessageSize);
            break;
            }

        case WSAEPFNOSUPPORT: {
            strncpy(cMessage, "Protocol family not supported", iMessageSize);
            break;
            }

        case WSAEPROCLIM: {
            strncpy(cMessage, "Too many processes", iMessageSize);
            break;
            }

        case WSAEPROTONOSUPPORT: {
            strncpy(cMessage, "Protocol not supported", iMessageSize);
            break;
            }

        case WSAEPROTOTYPE: {
            strncpy(cMessage, "Protocol wrong type for socket", iMessageSize);
            break;
            }

        case WSAESHUTDOWN: {
            strncpy(cMessage, "Cannot send after socket shutdown", iMessageSize);
            break;
            }

        case WSAESOCKTNOSUPPORT: {
            strncpy(cMessage, "Socket type not supported", iMessageSize);
            break;
            }

        case WSAETIMEDOUT: {
            strncpy(cMessage, "Connection timed out", iMessageSize);
            break;
            }

        case WSATYPE_NOT_FOUND: {
            strncpy(cMessage, "Class type not found", iMessageSize);
            break;
            }

        case WSAEWOULDBLOCK: {
            strncpy(cMessage, "Resource temporarily unavailable", iMessageSize);
            break;
            }

        case WSAHOST_NOT_FOUND: {
            strncpy(cMessage, "Host not found", iMessageSize);
            break;
            }

        case WSA_INVALID_HANDLE: {
            strncpy(cMessage, "Specified object handle is invalid", iMessageSize);
            break;
            }

        case WSA_INVALID_PARAMETER: {
            strncpy(cMessage, "One or more paramters are invalid", iMessageSize);
            break;
            }

        case WSAEINVALIDPROCTABLE: {
            strncpy(cMessage, "Invalid procedure table from service provider", iMessageSize);
            break;
            }

        case WSAEINVALIDPROVIDER: {
            strncpy(cMessage, "Invalid service provider version number", iMessageSize);
            break;
            }

        case WSA_IO_INCOMPLETE: {
            strncpy(cMessage, "Overlapped I/O event object not in signaled state", iMessageSize);
            break;
            }

        case WSA_IO_PENDING: {
            strncpy(cMessage, "Overlapped operations will complete later", iMessageSize);
            break;
            }

        case WSA_NOT_ENOUGH_MEMORY: {
            strncpy(cMessage, "Insufficient memory available", iMessageSize);
            break;
            }

        case WSANOTINITIALISED: {
            strncpy(cMessage, "Succesful WSAStartup() not yet performed", iMessageSize);
            break;
            }

        case WSANO_DATA: {
            strncpy(cMessage, "Valid name, no data record of requested type", iMessageSize);
            break;
            }

        case WSANO_RECOVERY: {
            strncpy(cMessage, "This is a non-recoverable error", iMessageSize);
            break;
            }

        case WSAEPROVIDERFAILEDINIT: {
            strncpy(cMessage, "Unable to initialize a service provider", iMessageSize);
            break;
            }

        case WSASYSCALLFAILURE: {
            strncpy(cMessage, "System call failure", iMessageSize);
            break;
            }

        case WSASYSNOTREADY: {
            strncpy(cMessage, "Network subsystem is unavailable", iMessageSize);
            break;
            }

        case WSATRY_AGAIN: {
            strncpy(cMessage, "Non-authoritative host not found", iMessageSize);
            break;
            }

        case WSAVERNOTSUPPORTED: {
            strncpy(cMessage, "WINSOCK.DLL version out of range", iMessageSize);
            break;
            }

        case WSAEDISCON: {
            strncpy(cMessage, "Graceful shutdown in progress", iMessageSize);
            break;
            }

        case WSA_OPERATION_ABORTED: {
            strncpy(cMessage, "Overlapped operation aborted", iMessageSize);
            break;
            }




        default: {
            strncpy(cMessage, "Unknown Error", iMessageSize);
            bRetValue = false;
            break;
            }
        };

    return bRetValue;
    }

//-----------------------------------------------------------------------------

void TWinSocket::LogMessage(char* cMessage) {

    FILE* hFile;

	 if (bDebugMode) {
       hFile = fopen("TWinSocket.txt", "a+");

       if (hFile!=NULL) {
           fwrite(cMessage, 1, strlen(cMessage), hFile);

           fclose(hFile);
           }
       }
    }

void TWinSocket::LogFunction(char* cFunctionName) {

    char        cOutput[1024];
    char        cTime[128];
    char        cSocket[128];

    itoa(hConnection, cSocket, 10);

    SYSTEMTIME  sSystemTime;

    GetSystemTime(&sSystemTime);
    GetTimeFormat(NULL, NULL, &sSystemTime, "HH':'mm':'ss", cTime, sizeof(cTime));

    strcpy(cOutput, "\n");
    strcat(cOutput, cTime);
    strcat(cOutput, "\t");
    strcat(cOutput, cFunctionName);
    strcat(cOutput, "\t");
    strcat(cOutput, cSocket);
    strcat(cOutput, "\t");

    LogMessage(cOutput);
    }

void TWinSocket::LogError() {

    if (bDebugMode) {
        //we zijn in debug mode, foutmelding loggen
        char cDebugMessage[256];

        FormatError(GetLastWinsockError(), cDebugMessage, sizeof(cDebugMessage));
        LogMessage(cDebugMessage);
        }
}
