//-----------------------------------------------------------------------------
//
// TInternetWaitPlayersDlg
//
// Dialoog dat getoond bij het wachten op andere spelers bij een internet spel
//
//-----------------------------------------------------------------------------

#include "main.h"
#pragma hdrstop

#include "31win.h"
#include "dynarray.h"
#include "31windlg.h"
#include "tinternetwaitplayersdlg.h"
#include "idh_constants.h"
#include "htmlhelp.h"



TCatchEnterEdit::TCatchEnterEdit(TWindow* parent, int resourceId,
								uint textLimit, TModule* module) :
                        TEdit(parent, resourceId, 0, 0) {

	}

void TCatchEnterEdit::EvKeyDown(uint key, uint repeatCount, uint flags) {

      switch (key) {

      	case VK_RETURN: {
         	Parent->PostMessage(WM_COMMAND, IDC_SEND ,(long)HWindow);
         	break;
            }

         case VK_TAB: {
         	Parent->PostMessage(WM_NEXTDLGCTL, 0, 0L);
            break;
            }

         default: {
         	TEdit::EvKeyDown(key, repeatCount, flags);
         	break;
         	}
      	};
	}

uint TCatchEnterEdit::EvGetDlgCode(MSG far* msg) {
   return DLGC_WANTALLKEYS ;
	}

DEFINE_RESPONSE_TABLE1(TCatchEnterEdit, TEdit)
	EV_WM_KEYDOWN,
	EV_WM_GETDLGCODE,
END_RESPONSE_TABLE;

TInternetWaitPlayersDlg::TInternetWaitPlayersDlg(TWindow* parent,int ResId)
  : CenterDialog(parent, ResId)
{
   EditIPHost = new TEdit(this, IDC_EDITHOSTIP);
	EditChatMessage = new TCatchEnterEdit(this, IDC_CHATEDIT, 128);

   ListChatMessages = new TListBox(this, IDC_LISTCHAT);
   ListPlayers = new TListBox(this, IDC_LISTPLAYERS);

   btnBoot = new TButton(this, IDC_BOOTPLAYER);
   btnOK = new TButton(this, IDOK);

   txtStep1 = new TStatic(this, IDC_STATIC1);
   txtStep2 = new TStatic(this, IDC_STATIC2);
   txtStep3 = new TStatic(this, IDC_STATIC3);

   nPlayers=1;

   for (int i=0; i<4; i++) {
      oPlayerSockets[i] = NULL;
		strcpy(PlNames[i], "");
		}
   }

TInternetWaitPlayersDlg::~TInternetWaitPlayersDlg() {

	delete oBoldFont;
	delete oConnectionSocket;
	}

DEFINE_RESPONSE_TABLE3(TInternetWaitPlayersDlg, CenterDialog, TDialog, TWindow)
	EV_COMMAND(IDC_SEND, CmSendMessage),
   EV_COMMAND(IDC_BOOTPLAYER, CmBootPlayer),
   EV_COMMAND(IDC_QUIT, CmAbortGame),
	EV_MESSAGE(WM_USER, CmAcceptMessage),
   EV_MESSAGE(WM_USER+1, CmUser1Message),
   EV_MESSAGE(WM_USER+2, CmUser2Message),
   EV_MESSAGE(WM_USER+3, CmUser3Message),
   EV_MESSAGE(WM_USER+4, CmUser4Message),
   EV_COMMAND_ENABLE(IDC_BOOTPLAYER, CeBootPlayer),
END_RESPONSE_TABLE;


void TInternetWaitPlayersDlg::CeBootPlayer(TCommandEnabler& ce) {

	bool bEnable = false;

   if (bHost) {
   	if (ListPlayers->GetSelIndex()>0) { // 0=host an mag niet gekicked worden
      	bEnable = true;
   		}
      }

   ce.Enable(bEnable);
}

void TInternetWaitPlayersDlg::SetupWindow() {

	CenterDialog::SetupWindow();

   //font aanpassen voor headers
	oBoldFont = new TFont("MS Sans Serif", 8, 0, 0, 0, FW_BOLD);

	txtStep1->SetWindowFont(*oBoldFont, true);
	txtStep2->SetWindowFont(*oBoldFont, true);
	txtStep3->SetWindowFont(*oBoldFont, true);

   //buttons aanpassen aan host zijnde of niet
   if (!bHost) {
      btnBoot->EnableWindow(false);
      btnOK->EnableWindow(false);

		for (int i=0; i<nPlayers; i++) {
			ListPlayers->AddString(PlNames[i]);
			}
		}
	else {
		ListPlayers->AddString(PlNames[0]);
		}

   //IP host invullen
   EditIPHost->SetCaption(cHostIP);

   if (bHost)
   	{
      oConnectionSocket=oWinSockets->NewListener(cHostIP, 10033, HWindow);
      }
   else {
      oPlayerSockets[0]->SetReadEvent(HWindow, 1);
   	}
	}


TResult TInternetWaitPlayersDlg::CmAcceptMessage(TParam1 id, TParam2 id2) {

   TWinSocket* oTempAcceptedConnection;
   int			nNewPlayer;
   char			cMessage[256];
   int			nPointer;

   switch (WSAGETSELECTEVENT(id2)) {

      case FD_ACCEPT: {

        if (oConnectionSocket!=NULL) {

            oTempAcceptedConnection = oConnectionSocket->AcceptConnection();

            if (nPlayers==4) {
               //spel zit vol
               oTempAcceptedConnection->SendMessage("GAMEFULL....", 12);
               delete oTempAcceptedConnection;
            	}
            else {
               nPointer = 1;
               do {
                  if (oPlayerSockets[nPointer]==NULL) {
                     oPlayerSockets[nPointer]=oTempAcceptedConnection;
                     oPlayerSockets[nPointer]->SetReadEvent(HWindow, nPointer+1);
               		oPlayerSockets[nPointer]->SendMessage("OK..........", 12);
                  	oTempAcceptedConnection=NULL;
                     nPlayers++;
                  	}
               	} while (oTempAcceptedConnection!=NULL && nPointer<4);

               if (oTempAcceptedConnection!=NULL) {
                  //er is iets misgegaan, maar we sturen maar game full terug
                  //voor de client maakt dat toch niet uit.
               	oTempAcceptedConnection->SendMessage("GAMEFULL....", 12);
               	delete oTempAcceptedConnection;
               	}
            	}
           }

        break;
        }
		}
    }

TResult TInternetWaitPlayersDlg::CmUser1Message(TParam1 id, TParam2 id2) {
   DoUserMessage(0, oPlayerSockets[0], id, id2);
	return NULL;
	}

TResult TInternetWaitPlayersDlg::CmUser2Message(TParam1 id, TParam2 id2) {
   DoUserMessage(1, oPlayerSockets[1], id, id2);
	return NULL;
	}

TResult TInternetWaitPlayersDlg::CmUser3Message(TParam1 id, TParam2 id2) {
   DoUserMessage(2, oPlayerSockets[2], id, id2);
	return NULL;
	}

TResult TInternetWaitPlayersDlg::CmUser4Message(TParam1 id, TParam2 id2) {
	DoUserMessage(3, oPlayerSockets[3], id, id2);
	return NULL;
 	}

void TInternetWaitPlayersDlg::DoUserMessage(int nPlayer, TWinSocket* poSocket, TParam1 id, TParam2 id2) {

   switch (WSAGETSELECTEVENT(id2)) {

      case FD_READ: {

        char cMessage[1024];
        char cNamePlayer[17];

			if (poSocket!=NULL) {

            recv(poSocket->hConnection, cMessage, sizeof(cMessage), 0);

            //naam bekend maken aan host
            if (strncmp(cMessage, "MYNAMEIS....", 12)==0) {
               if (bHost) {

               	strcpy(cNamePlayer, cMessage+12);

                  strcpy(PlNames[nPlayer], cNamePlayer);
						ListPlayers->AddString(cNamePlayer);

						//naam doorgeven aan andere spelers
                  strcpy(cMessage, "ADDPLAYER...");
						strcat(cMessage, cNamePlayer);

                  for (int i=1; i<4; i++) {
                  	if (i!=nPlayer) {
                        if (oPlayerSockets[i]!=NULL) {
                        	oPlayerSockets[i]->SendMessage(cMessage, strlen(cMessage)+1);
                        	}
								}
							}

						//lijst met participants doorgeven aan nieuwe speler
						::ZeroMemory(cMessage, sizeof(cMessage));
						strcpy(cMessage, "PARTICIPANTS");
						cMessage[12] = nPlayers + 65;
						strcpy(cMessage+13, PlNames[0]);
						strcpy(cMessage+30, PlNames[1]);
						strcpy(cMessage+47, PlNames[2]);
						strcpy(cMessage+64, PlNames[3]);

						oPlayerSockets[nPlayer]->SendMessage(cMessage, 82);
               	}
            	}

				//speler toevoegen aan lijst
				if (strncmp(cMessage, "ADDPLAYER...", 12)==0) {
					if (!bHost) {
						strcpy(cNamePlayer, cMessage+12);

						ListPlayers->AddString(cNamePlayer);
						}
					}

				//een speler heeft spel verlaten
				if (strncmp(cMessage, "IQUIT.......", 12)==0) {
					if (bHost) {
						delete oPlayerSockets[nPlayer];
						oPlayerSockets[nPlayer]=NULL;
						nPlayers--;

                  strcpy(cNamePlayer, PlNames[nPlayer]);
						strcpy(cMessage, "DELPLAYER...");
						strcat(cMessage, PlNames[nPlayer]);
						strcpy(PlNames[nPlayer], "");

						for (int i=1; i<4; i++) {
							if (oPlayerSockets[i]!=NULL) {
								oPlayerSockets[i]->SendMessage(cMessage, strlen(cMessage)+1);
                     	}
							}

						 char cTempString[25];
						 bool bFound;
						 int  iIndex=1; //host gaat niet weg

						 do {
							ListPlayers->GetString(cTempString, iIndex);

							if (strcmp(cTempString, cNamePlayer)==0) {
								bFound = true;
								ListPlayers->DeleteString(iIndex);
								}

							iIndex++;

							} while (!bFound && iIndex<ListPlayers->GetCount());
						}
					}

				//a player has left the game
				if (strncmp(cMessage, "DELPLAYER...", 12)==0) {
					if (!bHost) {
						 strcpy(cNamePlayer, cMessage+12);

						 char cTempString[25];
						 bool bFound;
						 int  iIndex=1; //host gaat niet weg

						 do {
							ListPlayers->GetString(cTempString, iIndex);

							if (strcmp(cTempString, cNamePlayer)==0) {
								bFound = true;
								ListPlayers->DeleteString(iIndex);
								}

							iIndex++;

							} while (!bFound && iIndex<ListPlayers->GetCount());
						 }
					}

				//you're booted by the host from the game
				if (strncmp(cMessage, "GOAWAY.........", 12)==0) {
					if (!bHost) {
						 delete oPlayerSockets[0];
						 oPlayerSockets[0]=NULL;

						 iCloseReason = 2; //booted by host
						 CloseWindow(IDCANCEL);
						}
					}

				//spel wordt afgesloten door host
				if (strncmp(cMessage, "GAMEABORT...", 12)==0) {
					if (!bHost) {
						 delete oPlayerSockets[0];
						 oPlayerSockets[0]=NULL;

						 iCloseReason = 1; //game aborted by host
						 CloseWindow(IDCANCEL);
						}
					}

            //chat bericht komt binnen
            if (strncmp(cMessage, "CHAT........", 12)==0) {

            	ListChatMessages->AddString(cMessage+12);

            	if (bHost) {
               	//als host moet je het bericht doorsturen naar de anderen
                  for (int i=1; i<4; i++) {
                  	if (oPlayerSockets[i]!=NULL) {
                       	oPlayerSockets[i]->SendMessage(cMessage, strlen(cMessage)+1);
                       	}
                  	}
                  }
					}

				//spel wordt gestart
				if (strncmp(cMessage, "STARTGAME...", 12)==0) {
					if (!bHost) {
						 CloseWindow(IDOK);
						}
					}

			}

        break;
        }
      }
	}

void TInternetWaitPlayersDlg::CmBootPlayer() {

   char cNamePlayer[20];
   char cMessage1[512];
   char cMessage2[512];

   ListPlayers->GetSelString(cNamePlayer, 20);
   ListPlayers->DeleteString(ListPlayers->GetSelIndex());

   strcpy(cMessage1, "GOAWAY......");
   strcpy(cMessage2, "DELPLAYER...");
   strcat(cMessage2, cNamePlayer);

   for (int i=1; i<4; i++) {

      if (oPlayerSockets[i]!=NULL) {
         if (strcmp(PlNames[i], cNamePlayer)==0) {
         	oPlayerSockets[i]->SendMessage(cMessage1, strlen(cMessage1)+1);
            delete oPlayerSockets[i];
            oPlayerSockets[i]=NULL;
            strcpy(PlNames[i], "");
            }
         else {
         	oPlayerSockets[i]->SendMessage(cMessage2, strlen(cMessage2)+1);
            }
         }
   	}
	}

void TInternetWaitPlayersDlg::CmSendMessage() {

	char cMessage[512];
   char cLine[256];

   strcpy(cMessage, "CHAT........");
   strcat(cMessage, cMyName);
   strcat(cMessage, ": ");
   
   EditChatMessage->GetLine(cLine, sizeof(cLine), 0);
   EditChatMessage->Clear();
   strcat(cMessage, cLine);

   if (bHost) {

      for (int i=1; i<4; i++) {
         if (oPlayerSockets[i]!=NULL) {
      		oPlayerSockets[i]->SendMessage(cMessage, strlen(cMessage)+1);
         	}
      	}

      ListChatMessages->AddString(cMessage+12);
   	}
   else {
      oPlayerSockets[0]->SendMessage(cMessage, strlen(cMessage)+1);
   	}

   }

void TInternetWaitPlayersDlg::CmAbortGame() {

	char cMessage[1024];

	if (bHost) {
		//hele spel wordt afgebroken
		strcpy(cMessage, "GAMEABORT...");
		for (int i=0; i<4; i++) {
			if (oPlayerSockets[i]!=NULL) {

				oPlayerSockets[i]->SendMessage(cMessage, strlen(cMessage)+1);
				delete oPlayerSockets[i];
            oPlayerSockets[i] = NULL;
				}
			}

		CloseWindow(IDCANCEL);
		}
	else {
		//ik verlaat het spel als enige speler
		strcpy(cMessage, "IQUIT.......");
		oPlayerSockets[0]->SendMessage(cMessage, strlen(cMessage)+1);
		delete oPlayerSockets[0];
      oPlayerSockets[0] = NULL;

		CloseWindow(IDCANCEL);
		}
	}


