; 31forWindows.nsi
;
; This script is based on example1.nsi, but it remember the directory, 
; has uninstall support and (optionally) installs start menu shortcuts.
;
; It will install makensisw.exe into a directory that the user selects,

!define VER_FILE "54"
!define VER_DISPLAY "5.4"

;--------------------------------

;Include Modern UI

  !include "MUI.nsh"
;--------------------------------

; The name of the installer
Name "31 for Windows ${VER_DISPLAY}"

!define MUI_ICON  "31win.ico"
!define MUI_UNICON  "31win.ico"

; The file to write
OutFile "31forWindows${VER_FILE}.exe"

; The default installation directory
InstallDir "$PROGRAMFILES\Meusesoft\31 for Windows"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\Meusesoft\31 for Windows" ""

;--------------------------------

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
 
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"


;--------------------------------

; The stuff to install
Section "31 for Windows (required)" 31forWindowsCore

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File "..\complete\31win.exe"
  File "..\complete\31win-en.chm"
  File "..\complete\31win-nl.chm"
  File "..\complete\sound1.wav"
  File "..\complete\sound2.wav"
  File "..\complete\sound3.wav"
  File "..\complete\sound4.wav"
  File "..\complete\sound5.wav"
  File "..\complete\card_01.bmp"
  File "..\complete\card_02.bmp"
  File "..\complete\card_03.bmp"
  File "..\complete\card_04.bmp"
  File "..\complete\card_05.bmp"
  
  ; Write the installation path into the registry
  WriteRegStr HKLM "SOFTWARE\Meusesoft\31 for Windows" "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\31forWindows" "DisplayName" "31 for Windows ${VER_DISPLAY}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\31forWindows" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\31forWindows" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\31forWindows" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts" 31forWindowsStart

  CreateDirectory "$SMPROGRAMS\31 for Windows"
  CreateShortCut "$SMPROGRAMS\31 for Windows\Uninstall.lnk" "$INSTDIR\uninstall.exe"
  CreateShortCut "$SMPROGRAMS\31 for Windows\31 for Windows.lnk" "$INSTDIR\31win.exe" "" "$INSTDIR\31win.exe" 0
  CreateShortCut "$SMPROGRAMS\31 for Windows\Help on 31 for Windows.lnk" "$INSTDIR\31win-en.chm"
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  SetDetailsPrint textonly
  DetailPrint "Deleting Registry Keys..."
  SetDetailsPrint listonly

  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\31forWindows"
  DeleteRegKey HKLM "SOFTWARE\Meusesoft\31 for Windows"
  DeleteRegKey HKCU "SOFTWARE\Meusesoft\31 for Windows"

  SetDetailsPrint textonly
  DetailPrint "Deleting Files..."
  SetDetailsPrint listonly

  ; Remove all files, if any
  Delete "$INSTDIR\*.*"
  Delete "$SMPROGRAMS\31 for Windows\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\31 for Windows"
  RMDir "$INSTDIR"

  
  SetDetailsPrint both

SectionEnd

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${31forWindowsCore} "The core files required for 31 for Windows"
  !insertmacro MUI_DESCRIPTION_TEXT ${31forWindowsStart} "Adds icons to your start menu"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

