#if !defined(windlg_h)
#define windlg_h



struct VariationData
{
   char VarName[40]; //Naam
	bool Fire;	// 3xAas is fire betekent 32.
   bool FireEveryOneLoses; // bij 3xAas krijgt de rest strafpunten.
   bool NeverTieWithLowestHand; //Nooit meerdere spelers met laagste punten.
   bool NeverTieWithLowest31; //Geen laagste met 30.5
   bool OneTurnAfterPass; // Na passen mag iedereen nog maar 1 keer.
	int NumberOfMarks; //Aantal streepjes.
   bool BonusMark; // een bonuspunt voor diegene die als eerste zou verliezen.
   bool AlwaysAWinner; // Altijd een winnaar, ook als overgebleven spelers hetzelfde aantal punten hebben.
};

VariationData HardGame = {"van Eer-Maas", false, false, false, true, true, 4, false, true};
VariationData EasyGame = {"Regular", false, false, false, false, false, 3, true, false};

struct TOptieStruct {
   char PName1[17];
   char PName2[17];
   char PName3[17];
	#if defined(BI_PLAT_WIN32)
  	TScrollBarData SpeedBar;
   #else
   uint16 Slow;
   uint16 Medium;
   uint16 Fast;
   #endif
   char PName4[17];
//  	uint16 Normaal;
//  	uint16 Hard;
  	uint16 SoundOn;
  	uint16 SoundOff;
//	char PFile[MAX_PATH+1];
};

struct TWizardStruct {
  	uint16 Single;
	uint16 Network;
	uint16 Internet;
   uint16 Show;
};

struct TNameStruct {
		TComboBoxData NameData;
};

struct TInternetGameStruct {
	TComboBoxData NameData;

	uint16 bHost;
   uint16 bClient;

	TComboBoxData IPData;

   char cHostIP[128];

};


struct TStatStruct {
	char SesPer[6];
	char SesWon[6];
	char SesLost[6];
	char TotPer[6];
	char TotWon[8];
	char TotLost[8];
	char SerWon[6];
	char SerLost[6];
	char Serrow[9];
};

struct TLoserStruct {
	char AppName[40];
};

struct TMessageStruct {
	char MessageText[512];
};
//---Centreren Dialoog---------------------------------------------------------
class CenterDialog: public TDialog
{
public:
	CenterDialog(TWindow *pWin, TResId id):
	TDialog(pWin, id) {}

	~CenterDialog(){};

	virtual void SetupWindow();
};
//-------------------
class TInternetButton : public TButton {
  	public:
    	TInternetButton(TWindow* parent, int resId);
   	~TInternetButton(); 

		void ODADrawEntire(DRAWITEMSTRUCT far& drawInfo);

  	protected:
  		void SetupWindow();

	private:
      TFont* InternetFont;
};
//---Opties Dialoog------------------------------------------------------------
class TWizardDlg: public CenterDialog {
	public:
   	TWizardDlg(TWindow* parent, int ResId, TWizardStruct& transfer);
};
//---Opties Dialoog------------------------------------------------------------
class TOptieDlg: public CenterDialog {
	public:
   	TOptieDlg(TWindow* parent, int ResId, bool taal, char name[26], TOptieStruct& transfer, TDynamicArray* VarArray);
      ~TOptieDlg();
      void SetupWindow();
      int VarSelect;
      bool Play;
      char VarSelName[64];
     	TComboBox* VariationCombo;

   protected:
      void OkPressed();
		void CeRegtest();
		void CeRegTest(TCommandEnabler& ce);
		void CePlay(TCommandEnabler& ce);
		void EvDrawItem(uint ctrlId, DRAWITEMSTRUCT far& drawInfo);
   	void EnableControls();
      void EditVariations();
      void FileClicked();
		#if defined(BI_PLAT_WIN32)
		void EvHelp(HELPINFO far& h);
      #endif

		#if defined(BI_PLAT_WIN32)
     	THSlider* Slider;
   	#else
      TRadioButton* SlowButton;
      TRadioButton* MediumButton;
      TRadioButton* FastButton;
   	#endif

     	TListBox* FileList;
      TRadioButton* StandardButton;
      TRadioButton* UserButton;
      TControl* BitmapControl;
	  	TEdit*		PictureName;
      bool engels;
      char OptionName[26];
       DECLARE_RESPONSE_TABLE(TOptieDlg);
   private:
   	TDynamicArray* VariationArray;
};
//---Nieuwe speler Dialoog-----------------------------------------------------
class TNameDlg : public CenterDialog {
  public:
	 TNameDlg(TWindow* parent, int ResId, TNameStruct& transfer);
};
//---Winnaar/Verliezen Dialoog-------------------------------------------------
class TAppWinDlg: public CenterDialog{
  public:
	 TAppWinDlg(TWindow* parent, int resId, TLoserStruct& transfer);
};
//---Nieuwe internet spel Dialoog----------------------------------------------
class TStartInternetDlg : public CenterDialog {
  public:
	 TStartInternetDlg(TWindow* parent, int ResId, TInternetGameStruct& transfer);
    ~TStartInternetDlg();

	 DECLARE_RESPONSE_TABLE(TStartInternetDlg);

    void CmRadioHost();
    void CmRadioClient();
    void SetupWindow();

  private:
  	 TComboBox* 	NameCombo;
    TComboBox* 	IPCombo;
    TRadioButton* radioHost;
    TRadioButton* radioClient;
    TEdit*        IPHost;
    TStatic* 	   txtStep1;
    TStatic* 	   txtStep2;
    TStatic* 	   txtStep3a;
	 TStatic* 	   txtStep3b;

	 TFont* oBoldFont;
  };


//---Order Dialoog------------------------------------------------------
class TOrderDlg: public CenterDialog{
  public:
	 TOrderDlg(TWindow* parent, int resId, bool engels);

	protected:
		void OpenRegtxt();
      void RegisterUser();
      void OrderOnline();

  	private:
      bool Engels;

      DECLARE_RESPONSE_TABLE(TOrderDlg);

};
//---Register Dialoog------------------------------------------------------
class TRegDlg: public CenterDialog{
  	public:
	 	TRegDlg(TWindow* parent, int resId, bool engels);
      void RegisterNow();

  	private:
      bool Engels;
      TEdit* RegEdit;

      DECLARE_RESPONSE_TABLE(TRegDlg);
};
//---Statistieken Dialoog------------------------------------------------------
class TStatDlg: public CenterDialog{
  public:
	 TStatDlg(TWindow* parent, int resId, TStatStruct& transfer);
};
//---Opzetten Netwerk Spel Dialoog---------------------------------------------
#if defined(BI_PLAT_WIN32)
class TNetworkDlg : public CenterDialog{
	public:
		TNetworkDlg(TWindow* parent, int ResId, bool engels, TDynamicArray* VarArray);
      void AddPossiblePlayer(char name[MAX_COMPUTERNAME_LENGTH+1], char OppName[21]);
      void DeletePlayer(char name[MAX_COMPUTERNAME_LENGTH+1]);
      void AddGame(char name[MAX_COMPUTERNAME_LENGTH+1], char OppName[50]);
      void DeleteGame(char name[MAX_COMPUTERNAME_LENGTH+1]);
      bool PlSelected;
      bool Available;
      char PlName[MAX_COMPUTERNAME_LENGTH+1];

      bool Host;
      bool WantPlayers;
      bool Joined;
      bool Reject;
      bool Spelen;
      bool WantInfo;
      char NameList[4][21];
      char ComputerList[4][MAX_COMPUTERNAME_LENGTH+1];
      char NameGamesList[100][50];
      char ComputerGamesList[100][MAX_COMPUTERNAME_LENGTH+1];
   	TListBox* PlayerList;
   	TListBox* GamesList;
		TComboBox* VariationBox;
	 	void EnableControls();

	protected:
		void CeInfo(TCommandEnabler& ce);
		void GetPlayers();
      void SetupWindow();
      void Select();
      void Stop();
      void Info();
      void PressReject();
      void PressStart();
      void IAmHost();
	 	void WannaJoin();
      void TestReg();

   private:
      TButton* JoinBut;
      TButton* HostBut;
      TButton* RejectBut;
      TButton* StartBut;
      TButton* InfoBut;
      bool Engels;
      TDynamicArray* VariationArray;

      DECLARE_RESPONSE_TABLE(TNetworkDlg);
};
//---Wachten op verbinding Dialoog---------------------------------------------
class TLinkDlg : public CenterDialog{
  public:
	 TLinkDlg(TWindow* parent, int ResId);

  bool	Waiting;

  protected:
	 void		TerminateWaiting();

DECLARE_RESPONSE_TABLE(TLinkDlg);
};
//---Berichten Dialoog-------------------------------------------------
class TMessageDlg: public CenterDialog {
	public:
   	TMessageDlg(TWindow* parent, int ResId, TMessageStruct& transfer);
      void AddMessage(char Message[512], bool reply=true);
      char OpponentName[MAX_COMPUTERNAME_LENGTH+1];
      char PlayerName[21];
      void HideDialog();
      void SetupWindow();
   	TListBox* MessageList;
      TEdit*	 MessageEdit;

   private:
   	void SendMessage();
      void ClearListbox();
      void CmOk();
      void CmCancel();
      TWindow* Parent;

DECLARE_RESPONSE_TABLE(TMessageDlg);
};

class TCompanyDialog : public TPropertyPage {
  	public:
	 	TCompanyDialog(TPropertySheet* parent, int ResId);
	  	~TCompanyDialog();

   protected:
		void GoToInternet();

   private:
   	TInternetButton* InetButton;

	DECLARE_RESPONSE_TABLE(TCompanyDialog);
};

class TAboutDialog : public TPropertyPage {
  	public:
	 	TAboutDialog(TPropertySheet* parent, int ResId);
	  	~TAboutDialog();

	protected:
	 	void SetupWindow();
		void GoToUltisoft();
		void GoToMeusesoft();
		void EvDrawItem(uint ctrlId, DRAWITEMSTRUCT far& drawInfo);

	private:
		TStatic* Static1;
   	TInternetButton* UltiButton;
   	TInternetButton* MSButton;

   DECLARE_RESPONSE_TABLE(TAboutDialog);
};

class TMyPropertySheet: public TPropertySheet
{
public:
    TMyPropertySheet(TWindow* parent, const char far* title, uint startPage = 0,
    						bool isWizard = false, uint32 flags = PSH_DEFAULT,
                     TModule* module = 0);
protected:
	 void SetupWindow();
};
#endif  //alleen win32

//---Variatie Dialoog------------------------------------------------------------
class TVariationDlg: public CenterDialog {
	public:
   	TVariationDlg(TWindow* parent, int ResId, bool taal);
   	TVariationDlg(TWindow* parent, int ResId, bool taal, VariationData VarData);
   	~TVariationDlg();
      void SetupWindow();
      void SaveRules();
      static void LoadRules(TDynamicArray* VarArray);
		static void LoadVariationsFromFile(FILE* in, TDynamicArray* VarArray);

   protected:
      void OkPressed();
		void CeFireMark(TCommandEnabler& ce);
		void CeBonusMark(TCommandEnabler& ce);
		void CeDeleteVariation(TCommandEnabler& ce);
		void CeReadOnly(TCommandEnabler& ce);
		void CeReadOnly2(TCommandEnabler& ce);
   	void EnableControls();
      void VariationClicked();
      void SaveVariation();
      void DeleteVariation();
      void NewVariation();
		#if defined(BI_PLAT_WIN32)
		void EvHelp(HELPINFO far& h);
      #endif

	  	TEdit*		  VarName;
     	TListBox* VariationList;
      TCheckBox* UseFire;
      TCheckBox* FireMark;
      TCheckBox* NeverTie31;
      TCheckBox* NeverTieHand;
	  	TEdit*		  NMarkEdit;
      TCheckBox* BonusMark;
      TCheckBox* OneTurnPass;
      TCheckBox* AlwaysWinner;

      TDynamicArray* VariationArray;

      bool engels;
      bool ReadOnly;

      DECLARE_RESPONSE_TABLE(TVariationDlg);
};
#endif
